#!/bin/bash
#
# change.cgi
#
# Copyright (C) 1997 Andreas Furbach <zene@afu.ping.de>
# Anpassungen an V4.0 von Reiner Klaproth <klaproth@online.de>,2003
# Neues Lock-Schema Klaus Werner < kwerner@ash.ks.he.schule.de>

passchange ()
{
 local SU_ID=SuSuSuSu
 local OK_ID=OkOkOkOk
 local LCK_ID=LCKLCK
 test -z "${FORM_newpass}" && return 2
 local RESULT="$(echo "${FORM_oldpass}" | /bin/su -s /bin/bash -l -c \
 "(echo "${SU_ID}"; \
      { echo "${FORM_oldpass}" | \
        sudo /usr/sbin/passchange "${FORM_newpass}" > /dev/null ; \
      erg="\$\?" ; }; \
      if   [ "\$erg" -eq "0" ]; then echo "${OK_ID}" ; \
      elif [ "\$erg" -eq "3" ]; then echo "${LCK_ID}" ; \
      fi ) " \
 ${FORM_uid} )"
 test -n "$(echo "${RESULT}" | grep "${LCK_ID}")" && return 3
 test -n "$(echo "${RESULT}" | grep "${OK_ID}")" && return 0
 test -n "$(echo "${RESULT}" | grep "${SU_ID}")" && return 1
 return 2
}

read QUERY_STRING
export QUERY_STRING
eval `cgiparse -form` 

cgiutils -ct text/html -cl de -expires now
cat header.php
cat nav.php
cat << xxxxxEOFxxxxx

<td class="main" bgcolor="white" valign="top">
<h3 align=center>Passwort &auml;ndern</h3>
<hr>
<h4 align=center><font color="#FF0000">Schlie&szlig;en Sie den Browser, bevor
Sie den Arbeitsplatz verlassen!</font></h4>
<hr>
<CENTER><H4>
xxxxxEOFxxxxx

if [ "${FORM_newpass}" = "${FORM_newpass1}" ]; then
	FEHLER=0
	# Stufe 1: Gibts den User?
	x=`grep "^${FORM_uid}:" /etc/passwd`
	if [ -z "$x" ]; then
		echo "<P><FONT COLOR=\"#800000\">Zugriff abgelehnt!</FONT><BR>"
		FEHLER=1
	    elif [ `echo $x | cut -d: -f3` -lt 1000 ]; then
		echo "<P><FONT COLOR=\"#800000\">Zugriff abgelehnt!</FONT><BR>"
		FEHLER=1
	    elif [ `echo $x | cut -d: -f4` -lt 101 ]; then
		echo "<P><FONT COLOR=\"#800000\">Zugriff abgelehnt!</FONT><BR>"
		FEHLER=1
	fi
	# Zweite Stufe: Ist das Passwort brauchbar?
	lpass=${#FORM_newpass}
	if [ $lpass -lt 5 ]; then
	         echo "<P><FONT COLOR=\"#800000\">Das neue Passwort war zu kurz!</FONT><BR>"
		 FEHLER=1
	fi
	echo "${FORM_newpass}" | grep -q -v -E "[^A-Za-z0-9_-]"
	if [ $? -gt 0 ] ; then
		echo "<P><FONT COLOR=\"#800000\">Das neue Passwort enthielt ung&uuml;ltige Zeichen! </FONT><BR>"
		FEHLER=1
	fi
	# letzter Test: funzt das alte Passwort?
	echo "${FORM_oldpass}" | grep -q -v -E "[^A-Za-z0-9_-]"
	if [ $? -gt 0 -o ${#FORM_oldpass} -lt 3 ] ; then
	         echo "<P><FONT COLOR=\"#A00000\">Das alte Passwort war ung&uuml;ltig!</FONT><BR>"
		 FEHLER=1
	fi
	if [ $FEHLER = 0 ]; then
	       passchange  
	       RESULT="${?}"
	       if [ "${RESULT}" = "0" ]; then
	               echo "<P><FONT COLOR=\"#008000\">Passwort ge&auml;ndert!</FONT>"
        	 elif [ "${RESULT}" = "3" ]; then 
        	       echo "<P><FONT COLOR=\"#800000\">Interface-Anforderung in Bearbeitung</FONT><BR>"
		       FEHLER=1
	         else
	               echo "<P><FONT COLOR=\"#800000\">Zugriff abgelehnt!</FONT><BR>"
	               if test -s /var/apache/tmp/passch ; then
	                  cat /var/apache/tmp/passch
			  rm -f /var/apache/tmp/passch
	               fi 
	               FEHLER=1
	         fi
	     fi
	else
	     echo "<p>Sie haben sich bei der Eingabe des neuen Passworts vertippt!</p>"
	     FEHLER=1
fi

if [ $FEHLER = 1 ]; then
     echo "<p>Das Passwort wurde nicht ge&auml;ndert!</p>"
     echo "<p><a href=\"passch.php\"><img src=\"images/back.png\" align=bottom border=0>
 Versuchen Sie es noch einmal!</a></p>"
fi

cat << xxxxxEOFxxxxx
</H4></CENTER>
<hr>
&copy; Klaus Werner, Reiner Klaproth, 1998-2003
</td>
xxxxxEOFxxxxx
cat footer.php
