#!/bin/bash
#
# userlist.cgi
#
# Copyright (C) 1998 Reiner Klaproth <klaproth@online.de>
#
### subroutine

export QUERY_STRING
eval `cgiparse -form`
HOST=`hostname -f`

cgiutils -ct text/html -cl de -expires now
cat header.php
cat nav.php
cat << xxxEOF1xxx

<td class="main" bgcolor="white" valign="top">
<H3>Nutzer-&Uuml;bersicht</H3>
<HR>
<P>

xxxEOF1xxx

if [ -z "${FORM_user}" ]; then
        # Eine neue Liste aufbauen
	cat << xxxEOF2xxx
Bitte w&auml;hlen Sie die Gruppe aus der Liste aus! 
<P>
<UL>
  <LI><A HREF="userlist.cgi?user=ALLE">ALLE</A>
xxxEOF2xxx

	x=`cat /etc/passwd | awk -F: '{
	    klasse=$5
	    sub("[^,]*", "", klasse);
	    sub("^,[    ]*", "", klasse);
	    sub("[  ]*,.*", "", klasse);
	    print  klasse 
	    }' | egrep -v '^[ "]*$' | sort | uniq
	`
	for klasse in $x ; do
	   if [ ! -z "$klasse" ]; then
	   echo "<LI><A HREF=\"userlist.cgi?user=${klasse}\">${klasse}</A>"
	   fi
	done
	echo "</UL>"

else
    # Der Username ist angegeben. Wir werten das per Liste aus.
    # Zuerst einen sicheren Dateinamen erzeugen
    TMPFILE=`mktemp -q /tmp/userlist.XXXXXX`
    if [ $? -ne 0 ];then
	echo "<BIG>Fehler beim Erzeugen der Liste!</BIG>"    
    else
	# Nun testen, ob die Angabe stimmt
	if `echo "${FORM_user}" | grep -q -E '[;/&|<>\`]' ` ; then
	    echo "<BIG>Falsche Angabe der Klasse</BIG></td>"
	    exit 0
	fi
	# und die "Klasse" muss auch existieren
	if ! [ ${FORM_user} = "ALLE" ]; then
	    if ! grep -q ",${FORM_user}:" /etc/passwd ; then
		echo "<BIG>Diese Klasse existiert nicht!</BIG></td>"
		exit 0
	    fi
	fi
	# OK, wir erzeugen die Seite
	echo "Benutzer auf $HOST in "
	if [ "${FORM_user}" = "ALLE" ]; then
		echo "alphabetischer Reihenfolge: <P>"
	else
		echo "Klasse ${FORM_user} : <P>"
	fi
	cat << xxxEOF4xxx

<TABLE BORDER WIDTH=80%>
<TR>
  <TH WIDTH=30%> Name </TH>
  <TH WIDTH=15%> Klasse </TH>
  <TH WIDTH=15%> E-Mail </TH>
  <TH WIDTH=20%> Homepage </TH>
</TR>
xxxEOF4xxx
	awk -F: '{
		if ( $3 > 999 )
		print $1 "," $5 }' /etc/passwd | grep -v "^nobody" | sort > $TMPFILE.tmp

	if [ ! "${FORM_user}" = "ALLE" ]; then
		grep ",${FORM_user}\$" $TMPFILE.tmp >$TMPFILE
		rm -f $TMPFILE.tmp
	   else
	        mv $TMPFILE.tmp $TMPFILE
	fi

	# Formatieren der Liste
	DOMAIN=`domainname`
	awk -F, -v domain="$DOMAIN" -v host="$HOST" '{
		print "<TR><TD>&nbsp;" $2 "</TD><TD>&nbsp;" $3 \
	   "</TD><TD><center><A HREF=\"mailto:" $1 "\@" domain "\"><IMG SRC=\"images/mail_generic.png\" border=\"0\"> " \
	   "</center></A></TD><TD><center><A HREF=\"http://" host "/\~" $1 "/" "\"><IMG SRC=\"images/gohome.png\" border=\"0\"> " \
	   "</center></A></TD></TR>"
	}' $TMPFILE

	rm -f $TMPFILE

	echo "</TABLE>"
    fi
fi

cat << xxxEOFxxx
<P><HR>Letzte &Auml;nderung: 30.03.2003

<P>&copy; 
Reiner Klaproth

</td>
xxxEOFxxx
cat footer.php
